/* scatterlist compatibility for pre-2.6.15 kernels */

#ifndef _LINUX_SCATTERLIST_BACKPORT_2_6_14_H
#define _LINUX_SCATTERLIST_BACKPORT_2_6_14_H

#include <asm/scatterlist.h>
#include <linux/mm.h>
#include <linux/string.h>

#include_next <linux/scatterlist.h>

static inline void sg_set_buf(struct scatterlist *sg, const void *buf,
			      unsigned int buflen)
{
	sg->page = virt_to_page(buf);
	sg->offset = offset_in_page(buf);
	sg->length = buflen;
}

#endif
